select
(CASE
 WHEN p.Liefertermin IS Null THEN v.Vorgangsdatum
 ELSE p.Liefertermin
 END) As Termin, v.Lieferdatum,
(CASE
 WHEN p.Lieferanzahl IS NULL THEN p.Anzahl
 WHEN (p.Anzahl-p.Lieferanzahl)<0 THEN 0.00
 ELSE (p.Anzahl-p.Lieferanzahl)
 END) AS Rueckstand,
 t.BezeichnungNr,v.Vorgangsnummer,a.Nummer,a.Suchbegriff,a.*,p.*,v.*
 from Positionen p left outer join auftrag v on p.Auftrag=v.auftrag left outer join adressen a on v.adresse1=a.adresse left outer join Auftrag_Art t on v.art=t.Art
where (
       ((t.art IN (2) or t.L_Auftrag=1) and p.Art IN (0,2,10,12,13,14))
    or ((t.art IN (100) or t.L_Fertigung=1) and p.Art IN (10))
    AND
( 
( ISNULL(v.Deaktiviert,0)=1 and  ISNULL(p.STBuchen,0)=0)
 or
( ISNULL(v.Deaktiviert,0)=0 and  ISNULL(p.Ebene,0)=0)
))    
 and ( ISNULL(v.gedruckt,0)=1 or ISNULL(v.Gemailt,0)=1 or ISNULL(v.ZBericht,0)=1) and ISNULL(v.abgeschlossen,0) = 0 and ISNULL(v.storniert,0) = 0 
 and p.Artikel=:Artikel
AND
(CASE
 WHEN p.Lieferanzahl IS NULL THEN p.Anzahl
 WHEN (p.Anzahl-p.Lieferanzahl)<0 THEN 0.00
 ELSE (p.Anzahl-p.Lieferanzahl)
 END)>0.00001
ORDER BY
(CASE
 WHEN p.Liefertermin IS Null THEN v.Vorgangsdatum
 ELSE p.Liefertermin
 END), v.Lieferdatum