select
 z.Kassenname AS Z_KASSE_ID,
 z.Datum AS Z_ERSTELLUNG,
 z.Nummer AS Z_NR,
 v.Vorgangsnummer AS BON_ID,
 p.Pos AS POS_ZEILE,
 '' as GUTSCHEIN_NR,
 p.PBezeichnung AS ARTIKELTEXT,
 v.shopid AS POS_TERMINAL_ID,
 (CASE
  WHEN v.TSE_TA_VORGANGSART=1 THEN 'AVTransfer'
  WHEN v.TSE_TA_VORGANGSART=2 THEN 'AVBestellung'
  WHEN v.TSE_TA_VORGANGSART=3 THEN 'AVTraining'
  WHEN v.TSE_TA_VORGANGSART=4 THEN 'AVBelegstorno'
  WHEN v.TSE_TA_VORGANGSART=5 THEN 'AVBelegabbruch'
  WHEN v.TSE_TA_VORGANGSART=6 THEN 'AVSachbezug'
  WHEN v.TSE_TA_VORGANGSART=7 THEN 'AVRechnung'
  WHEN v.TSE_TA_VORGANGSART=8 THEN 'AVSonstige'
  ELSE 'Beleg'
 END) as GV_TYP,
 t.Bezeichnung as GV_Name,
 '' as INHAUS,
 '' as P_STORNO,
 '' as AGENTUR_ID,
 p.Bestellnummer AS ART_NR,
 a.EANNummer AS GTIN,
 w.Warengruppe as WARENGR_ID,
 w.Bezeichnung as WARENGR,
 (CASE
  WHEN (p.Art IN (0,2,13,15)) THEN 1
  WHEN (p.Art=6) THEN -1
  ELSE 0
 END) * p.Anzahl as MENGE,
 ISNULL(p.Faktor,1)* ISNULL(p.Preiseinheit,1) AS FAKTOR,
 a.Einheit as EINHEIT,
(CASE
  WHEN v.Steuer<2 THEN 1
  ELSE (100+m.NEU_MWST)/100
END)
*((100- ISNULL(p.Rabatt,0) )/100)*((100- ISNULL(p.Rabatt2,0) )/100)*((100- ISNULL(p.Rabatt3,0) )/100)*((100- ISNULL(p.RabattG,0) )/100)*((100- ISNULL(v.GRabatt,0) )/100)
*p.Preis AS STK_BR
 from positionen p
 left outer join auftrag v on p.Auftrag=v.Auftrag
 left outer join auftrag_art t on t.Art=v.Art
 left outer join zbericht z on z.Nummer=v.Abo
 left outer join artikel a on a.Artikel=p.Artikel
 left outer join warengruppe w on a.Warengruppe=w.Warengruppe
 left outer join mwst m ON CASE WHEN p.SonderUST>0 THEN p.SonderUST ELSE a.Umsatzsteuer END=m.MwSt_Satz
WHERE v.Mandant=1 AND v.Abo=z.Zaehler and v.Art<>12 AND z.Datum BETWEEN '2020-03-04' and '2020-03-04'
ORDER BY v.Filiale, v.Vorgangsnummer, p.Pos, p.zaehler
