SELECT p.auftrag,p.artikel,p.art,p.pos,
(select {MSSQLTOP1} pox.zaehler FROM positionen pox where pox.Art=10 and pox.auftrag=p.auftrag and COALESCE(pox.artikel,0)=COALESCE(p.artikel,0) order by pox.Anzahl {MYSQLTOP1}) as zaehler,
(select {MSSQLTOP1} pox.POS FROM positionen pox where pox.auftrag=p.auftrag and COALESCE(pox.artikel,0)=COALESCE(p.artikel,0) order by pox.sort,pox.zaehler {MYSQLTOP1}) as POSX
, Pos_Art.Bezeichnung AS PosArt, p.bestellnummer,p.pbezeichnung, p.Liefertermin, p.Auswertung, p.WARE4, cast(p.Zusatztext1 AS {VAR}CHAR(255)) as Zusatztext1, cast(p.Bemerkung AS {VAR}CHAR(255)) as Bemerkung
, a.Artikelnummer,a.EANNummer,a.Zusatznummer,a.Bezeichnung,a.Bestand,a.Reserviert,a.Bestellt,a.Mindestbestand,a.Einheit,a.Lieferbar,a.Warengruppe,a.EK As ArtikelEK,a.MEK As ArtikelMEK
, a.Lagernummer,a.Lagerort1,a.Lagerort2,a.Hersteller,a.Herstellernr,a.NichtKommissionieren,a.PreiseinheitEinkauf
, w.Bezeichnung As Warenbezeichnung,w.Bondruck,w.AbweichendeUST,w.UseSteuer
, f.Eigenfertigung_EK,f.Eigenfertigung,f.Artikel_Type,f.Arbeitsvorbereitung,f.CAD_Datum,f.CAD_Info,f.LiZeit_min,f.LiZeit_max,f.FeZeit,f.Kanban2              
,(select MIN(poy.Liefertermin) FROM positionen poy where poy.auftrag=p.auftrag and poy.artikel=p.artikel and poy.Liefertermin IS NOT NULL) as erstesLieferdatum
,SUM(coalesce(p.anzahl,0)) As Gesamtanzahl
,COUNT(*) As Vorkommen

, CASE f.Artikel_Type
        WHEN 0 THEN 'Unbekannt'
        WHEN 1 THEN 'Kaufteil'
        WHEN 2 THEN 'CAD-Teil'
        ELSE 'Nicht definiert'
    END AS Artikeltype_Text
, CASE f.Eigenfertigung
        WHEN 0 THEN 'Unbekannt'
        WHEN 1 THEN 'Eigenfertigung'
        WHEN 2 THEN 'Externe Fertigung'
        ELSE 'Nicht definiert'
    END AS Fertigungstype_Text

                                                                                         
FROM positionen p
 LEFT OUTER JOIN Pos_Art ON p.Art=Pos_Art.Art
 LEFT OUTER JOIN Artikel a ON p.Artikel=a.Artikel           
 LEFT OUTER JOIN Artikel_Fertigung f ON f.Artikel=p.Artikel
 LEFT OUTER JOIN Warengruppe w ON a.Warengruppe=w.Warengruppe

 WHERE p.auftrag={AUFTRAG} AND p.art=10 {FILTER} {AUSWERTUNGSFILTER} {BEMERKUNGSSFILTER} {FILTERAP}
                                     

GROUP BY  p.auftrag,p.artikel,p.art,p.pos,Pos_Art.Bezeichnung, p.bestellnummer,p.pbezeichnung, p.Liefertermin, p.Auswertung, p.WARE4, cast(p.Zusatztext1 AS {VAR}CHAR(255)), cast(p.Bemerkung AS {VAR}CHAR(255))
, a.Artikelnummer,a.EANNummer,a.Zusatznummer,a.Bezeichnung,a.Bestand,a.Reserviert,a.Bestellt,a.Mindestbestand,a.Einheit,a.Lieferbar,a.Warengruppe,a.EK,a.MEK
, a.Lagernummer,a.Lagerort1,a.Lagerort2,a.Hersteller,a.Herstellernr,a.NichtKommissionieren,a.PreiseinheitEinkauf
, w.Bezeichnung,w.Bondruck,w.AbweichendeUST,w.UseSteuer
, f.Eigenfertigung_EK,f.Eigenfertigung,f.Artikel_Type,f.Arbeitsvorbereitung,f.CAD_Datum,f.CAD_Info,f.LiZeit_min,f.LiZeit_max,f.FeZeit,f.Kanban2       
                                                                                                                                                          
UNION

SELECT p.auftrag,p.artikel,p.art,p.pos,
(select {MSSQLTOP1} pox.zaehler FROM positionen pox where pox.Art=100 and pox.auftrag=p.auftrag and COALESCE(pox.artikel,0)=COALESCE(p.artikel,0) order by pox.Anzahl {MYSQLTOP1}) as zaehler,
(select {MSSQLTOP1} pox.POS FROM positionen pox where pox.auftrag=p.auftrag and COALESCE(pox.artikel,0)=COALESCE(p.artikel,0) order by pox.sort,pox.zaehler {MYSQLTOP1}) as POSX
, Pos_Art.Bezeichnung AS PosArt, p.bestellnummer,p.pbezeichnung, p.Liefertermin, p.Auswertung, p.WARE4, cast(p.Zusatztext1 AS {VAR}CHAR(255)) as Zusatztext1, cast(p.Bemerkung AS {VAR}CHAR(255)) as Bemerkung
, a.Artikelnummer,a.EANNummer,a.Zusatznummer,a.Bezeichnung,a.Bestand,a.Reserviert,a.Bestellt,a.Mindestbestand,a.Einheit,a.Lieferbar,a.Warengruppe,a.EK As ArtikelEK,a.MEK As ArtikelMEK
, a.Lagernummer,a.Lagerort1,a.Lagerort2,a.Hersteller,a.Herstellernr,a.NichtKommissionieren,a.PreiseinheitEinkauf
, w.Bezeichnung As Warenbezeichnung,w.Bondruck,w.AbweichendeUST,w.UseSteuer
, f.Eigenfertigung_EK,f.Eigenfertigung,f.Artikel_Type,f.Arbeitsvorbereitung,f.CAD_Datum,f.CAD_Info,f.LiZeit_min,f.LiZeit_max,f.FeZeit,f.Kanban2              
,(select MIN(poy.Liefertermin) FROM positionen poy where poy.auftrag=p.auftrag and poy.artikel=p.artikel and poy.Liefertermin IS NOT NULL) as erstesLieferdatum
,SUM(coalesce(p.anzahl,0)) As Gesamtanzahl
,COUNT(*) As Vorkommen

, CASE f.Artikel_Type
        WHEN 0 THEN 'Unbekannt'
        WHEN 1 THEN 'Kaufteil'
        WHEN 2 THEN 'CAD-Teil'
        ELSE 'Nicht definiert'
    END AS Artikeltype_Text
, CASE f.Eigenfertigung
        WHEN 0 THEN 'Unbekannt'
        WHEN 1 THEN 'Eigenfertigung'
        WHEN 2 THEN 'Externe Fertigung'
        ELSE 'Nicht definiert'
    END AS Fertigungstype_Text

                                                                                         
FROM positionen p
 LEFT OUTER JOIN Pos_Art ON p.Art=Pos_Art.Art
 LEFT OUTER JOIN Artikel a ON p.Artikel=a.Artikel           
 LEFT OUTER JOIN Artikel_Fertigung f ON f.Artikel=p.Artikel
 LEFT OUTER JOIN Warengruppe w ON a.Warengruppe=w.Warengruppe
                             
 WHERE p.auftrag={AUFTRAG} AND p.art IN (17,14,100) {FILTER} {AUSWERTUNGSFILTER} {BEMERKUNGSSFILTER} {FILTERAP}
                                     

GROUP BY  p.auftrag,p.artikel,p.art,p.pos,Pos_Art.Bezeichnung, p.bestellnummer,p.pbezeichnung, p.Liefertermin, p.Auswertung, p.WARE4 , cast(p.Zusatztext1 AS {VAR}CHAR(255)), cast(p.Bemerkung AS {VAR}CHAR(255))
, a.Artikelnummer,a.EANNummer,a.Zusatznummer,a.Bezeichnung,a.Bestand,a.Reserviert,a.Bestellt,a.Mindestbestand,a.Einheit,a.Lieferbar,a.Warengruppe,a.EK,a.MEK
, a.Lagernummer,a.Lagerort1,a.Lagerort2,a.Hersteller,a.Herstellernr,a.NichtKommissionieren,a.PreiseinheitEinkauf
, w.Bezeichnung,w.Bondruck,w.AbweichendeUST,w.UseSteuer                   
, f.Eigenfertigung_EK,f.Eigenfertigung,f.Artikel_Type,f.Arbeitsvorbereitung,f.CAD_Datum,f.CAD_Info,f.LiZeit_min,f.LiZeit_max,f.FeZeit,f.Kanban2       
                                                                                                                                                          

                                                                                                                                                   
ORDER BY POSX,p.Artikel,p.art                                  